<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  content.cs_tmb_fancybox
 *
 * @copyright   (C) 2025 www.codersite.ru
 * @license     GNU General Public License version 2 or later;
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use CS\Plugin\Content\CsTmbFancybox\Extension\CsTmbFancybox;

return new class () implements ServiceProviderInterface {
    public function register(Container $container): void
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
	            $config = (array) PluginHelper::getPlugin('content', 'cs_tmb_fancybox');
	            $subject = $container->get(DispatcherInterface::class);
	            $app = Factory::getApplication();

	            $plugin = new CsTmbFancybox($subject, $config);
	            $plugin->setApplication($app);

	            return $plugin;
            }
        );
    }
};
