<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_vuearticle
 *
 * @copyright   (C) 2025 www.codersite.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace CS\Module\Vuearticle\Site\Dispatcher;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use Joomla\CMS\Uri\Uri;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Dispatcher class for mod_vuearticle
 *
 * @since  4.4.0
 */
class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
    use HelperFactoryAwareTrait;

    /**
     * Returns the layout data.
     *
     * @return  array
     *
     * @since   4.4.0
     */
    protected function getLayoutData(): array
    {
        $data = parent::getLayoutData();

        $moduleName = $this->module->module;
        $moduleUri = Uri::root() . 'modules/' . $moduleName . '/';

        // Добавляем путь к папке модуля в массив данных
        $data['moduleUri'] = $moduleUri;

        return $data;
    }
}
