<?php
namespace CS\Plugin\Ajax\AjaxContenthelper\Extension;

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Database\ParameterType;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Event\Result\ResultAwareInterface;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\CMS\Log\Log;
   
class Contenthelper extends CMSPlugin implements SubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            'onAjaxGetArticles' => 'onAjaxGetArticles',
        ];
    }
    public function onAjaxGetArticles(Event $event)
    {
        $app = Factory::getApplication();

        $categoryId = $app->input->getInt('catid', 0);
        $isImage = $app->input->getString('image', '');
        $ordering = $app->input->getString('ordering', 'a.publish_up');
        $direction = $app->input->getString('direction', 'DESC');
        $count = $app->input->getInt('count', 1);
        if ($categoryId <= 0) {
            $output = "Ошибка: ID категории не указан или недействителен.";
        } else {
            $db = Factory::getContainer()->get(DatabaseInterface::class);

            $query = $db->getQuery(true)
                ->select(
                    [
                        $db->quoteName('a.id', 'id'),
                        $db->quoteName('a.catid', 'catid'),
                        $db->quoteName('a.title', 'title'),
                        $db->quoteName('a.alias', 'alias'),
                        $db->quoteName('a.images', 'images'),
                        $db->quoteName('a.introtext', 'introtext'),
                    ]
                )
                ->setLimit($count)
                ->from($db->quoteName('#__content', 'a'))
                ->where($db->quoteName('a.catid') . ' = :catid') // Используем псевдоним 'a'
                ->where($db->quoteName('a.state') . ' = 1');

            if ($ordering == 'rand()') {
                $query->order($query->rand());
            } else {
                $query->order($db->quoteName($ordering) . ' ' . $direction);
            }
            $query->bind(':catid', $categoryId, ParameterType::INTEGER);
            $db->setQuery($query);

            try {
                $result = $db->loadObjectList();
                $articles = [];
                foreach ($result as $article) {
                    // Формируем URL
                    $article->url = Route::_(RouteHelper::getArticleRoute($article->id . ':' . $article->alias, $article->catid));
                    //unset($article->alias);
                    // Формируем Изображение
                    if ($isImage) {
                        $images = json_decode($article->images);
                        $imageType = 'image_intro';
                        if ($isImage == 'intro') {
                            $imageType = 'image_intro';
                        } elseif ($isImage == 'full') {
                            $imageType = 'image_fulltext';
                        }
                        $img = HTMLHelper::_('cleanImageUrl', $images->$imageType);
                        $article->image = $img;
                    }
                    $articles[] = $article;
                }

                $output = json_encode($articles);
            } catch (\Exception $e) {
                // Обработка ошибки запроса
                $output = "Ошибка базы данных: " . $e->getMessage();
                // Логируем ошибку
                Log::add('Плагин AjaxContenthelper: ' . $e->getMessage(), \Joomla\CMS\Log\Log::ERROR, 'plg_ajax_contenthelper');
            }
        }

        // Добавляем результат в событие
        if ($event instanceof ResultAwareInterface) {
            $event->addResult($output);
        } else {
            $result = $event->getArgument('result') ?? [];
            $result[] = $output;
            $event->setArgument('result', $result);
        }
    }
}