<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  pkg_vuearticles
 * @author      CS <info@codersite.ru>
 *
 * @copyright   (C) 2025 CS <https://www.codersite.ru>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @since       1.0.0
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Application\AdministratorApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Installer\InstallerScriptInterface;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Version;
use Joomla\Database\DatabaseDriver;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Database\ParameterType;

return new class () implements ServiceProviderInterface {

    public function register(Container $container): void
    {
        $container->set(InstallerScriptInterface::class, new class ($container->get(AdministratorApplication::class)) implements InstallerScriptInterface {
            /**
             * The application object
             *
             * @var AdministratorApplication $app
             *
             * @since 1.0.0
             */
            protected AdministratorApplication $app;

            /**
             * The Database object.
             *
             * @var DatabaseDriver $db
             *
             * @since 1.0.0
             */
            protected DatabaseDriver $db;

            /**
             * Minimum Joomla version required to install the extension.
             *
             * @var string $minimumJoomla
             *
             * @since 1.0.0
             */
            protected string $minimumJoomla = '4.4';

            /**
             * Minimum PHP version required to install the extension.
             *
             * @var string $minimumPhp
             *
             * @since 1.0.0
             */
            protected string $minimumPhp = '8.0';

            /**
             * @var array $providersInstallationMessageQueue
             *
             * @since 2.0.3
             */
            protected $providersInstallationMessageQueue = [];

            /**
             * Constructor.
             *
             * @param AdministratorApplication $app The application object.
             *
             * @since 1.0.0
             */
            public function __construct(AdministratorApplication $app)
            {
                $this->app = $app;
                $this->db = Factory::getContainer()->get('DatabaseDriver');
            }

            /**
             * Function called after the extension is installed.
             *
             * @param   InstallerAdapter  $adapter  The adapter calling this method
             *
             * @return  boolean  True on success
             *
             * @since   1.0.0
             */
            public function install(InstallerAdapter $adapter): bool
            {
                return true;
            }

            /**
             * Function called after the extension is updated.
             *
             * @param   InstallerAdapter  $adapter  The adapter calling this method
             *
             * @return  boolean  True on success
             *
             * @since   1.0.0
             */
            public function update(InstallerAdapter $adapter): bool
            {
                return true;
            }

            /**
             * Function called after the extension is uninstalled.
             *
             * @param   InstallerAdapter  $adapter  The adapter calling this method
             *
             * @return  boolean  True on success
             *
             * @since   1.0.0
             */
            public function uninstall(InstallerAdapter $adapter): bool
            {
                return true;
            }

            /**
             * Function called before extension installation/update/removal procedure commences.
             *
             * @param   string            $type     The type of change (install or discover_install, update, uninstall)
             * @param   InstallerAdapter  $adapter  The adapter calling this method
             *
             * @return  boolean  True on success
             *
             * @since   1.0.0
             */
            public function preflight(string $type, InstallerAdapter $adapter): bool
            {
                return true;
            }

            /**
             * Function called after extension installation/update/removal procedure commences.
             *
             * @param   string            $type     The type of change (install or discover_install, update, uninstall)
             * @param   InstallerAdapter  $adapter  The adapter calling this method
             *
             * @return  boolean  True on success
             *
             * @since   1.0.0
             */
            public function postflight(string $type, InstallerAdapter $adapter): bool
            {
                $elementName = 'contenthelper'; 
                $extensionType = 'plugin';

            	$db = Factory::getContainer()->get('DatabaseDriver'); 

							$query = $db->getQuery(true)
							    ->update($db->quoteName('#__extensions')) 
							    ->set($db->quoteName('enabled') . ' = 1')
							    ->where($db->quoteName('element') . ' = :element') 
							    ->where($db->quoteName('type') . ' = :type');

							$query->bind(':element', $elementName, ParameterType::STRING); 
							$query->bind(':type', $extensionType, ParameterType::STRING);

							$db->setQuery($query);
							$db->execute();

	            return true;
            }

	        /**
	         * Method to check compatible.
	         *
	         * @return  boolean True on success, False on failure.
	         *
	         * @throws  Exception
	         *
	         * @since  1.0.0
	         */
	        protected function checkCompatible(string $element): bool
	        {
		        $element = strtoupper($element);
		        // Check joomla version
		        if (!(new Version)->isCompatible($this->minimumJoomla)) {
			        $this->app->enqueueMessage(
				        Text::sprintf($element . '_ERROR_COMPATIBLE_JOOMLA', $this->minimumJoomla),
				        'error'
			        );

			        return false;
		        }

		        // Check PHP
		        if (!(version_compare(PHP_VERSION, $this->minimumPhp) >= 0)) {
			        $this->app->enqueueMessage(
				        Text::sprintf($element . '_ERROR_COMPATIBLE_PHP', $this->minimumPhp),
				        'error'
			        );

			        return false;
		        }

		        return true;
	        }
        });
    }
};