<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_taglist
 *
 * @copyright   2025, @ CoderSite
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Module\Taglist\Site\Helper;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use Joomla\Database\DatabaseAwareInterface;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Database\ParameterType;
use Joomla\Registry\Registry;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Helper for mod_taglist
 *
 * @since  1.5
 */
class TaglistHelper implements DatabaseAwareInterface
{
    use DatabaseAwareTrait;

    /**
     * Returns a list from an array
     *
     * @param   Registry         $moduleParams  The module parameters.
     * @param   SiteApplication  $app           The current application.
     *
     * @return  \stdClass[]
     *
     * @since   4.4.0
     */
    public function getModuleData(Registry $moduleParams, SiteApplication $app): array
    {
	    $lists = [];

	    if ($moduleParams->get('tags')){
		    $tagids = implode(",",$moduleParams->get('tags'));
	    } else {
		    return $lists = ['error' => 'Выберите Тег'];
	    }
	    $limit = $moduleParams->get('count', 5);
	    $sortby = $moduleParams->get('sortby', 'name');
	    $direction = $moduleParams->get('direction', 'ASC');
		$typetags = $moduleParams->get('typetags', 'id');

	    // Get a db connection.
	    $db = Factory::getContainer()->get('DatabaseDriver');
	    $query = $db->getQuery(true);

	    $query->select($db->quoteName(['id','parent_id','title','alias','path','language']));
	    $query->from($db->quoteName('#__tags'));
	    $query->where($db->quoteName($typetags). ' IN (' . $tagids . ')');
	    $query->where($db->quoteName('published') . " = 1");
	    if($direction == 'RAND'){
		    $query->order('RAND()');
	    } else {
		    $query->order($db->quoteName($sortby) . ' '.$direction);
	    }
	    $query->setLimit($limit);

	    $db->setQuery($query);

	    $lists = $db->loadAssocList();

        return $lists;
    }


}
