<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_taglist
 * @var     $list     array
 *
 * @copyright   2025, @ CoderSite
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die;
use Joomla\CMS\Router\Route;
use Joomla\Component\Tags\Site\Helper\RouteHelper;
?>
<ul class="mod-taglist list-group list-group-flush">
    <?php
    if(isset($list['error'])){?>
        <div class="alert alert-warning" role="alert">
            <?php echo $list['error'];?>
        </div>
    <?php
    } else if(isset($list)){?>
	    <?php foreach ($list as $item) : ?>
        <li class="list-group-item">
            <?
           // dd($item);
            ?>
            <a href="<?php echo Route::_(RouteHelper::getComponentTagRoute($item['id'] . ':' . $item['alias'], $item['language'])); ?>">
			    <?php echo htmlspecialchars($item['title'], ENT_COMPAT, 'UTF-8'); ?></a>
        </li>
        <?php endforeach; ?>
    <?php
    }
    ?>
</ul>
