<?php

/**
 * @package     Mitriy_Bug
 * @subpackage  mod_articles_swiper
 *
 * @copyright   (C) 2025 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $app->getDocument()->getWebAssetManager();
$wa->registerAndUseStyle('mod_articles_swiper', 'mod_articles_swiper/swiper-bundle.min.css');
$wa->registerAndUseScript('mod_articles_swiper', 'mod_articles_swiper/swiper-bundle.min.js');

if (!$list) {
    return;
}

$groupHeading = 'h4';

if ((bool) $module->showtitle) {
    $modTitle = $params->get('header_tag');

    if ($modTitle == 'h1') {
        $groupHeading = 'h2';
    } elseif ($modTitle == 'h2') {
        $groupHeading = 'h3';
    }
}

$layoutSuffix = $params->get('title_only', 0) ? '_titles' : '_items';

//echo $params->get('layout_columns');
//dd($module);
?>
<div class="swiper swiper_<?php echo $module->id; ?> pb-4">
    <ul class="swiper-wrapper">
            <?php $items = $list; ?>
            <?php require ModuleHelper::getLayoutPath('mod_articles_swiper', $params->get('layout', 'swiper') . $layoutSuffix); ?>
    </ul>
    <?php if ($params->get('pagination')===1) :?>
        <div class="swiper-pagination swiper-pagination_<?php echo $module->id; ?>"></div>
    <?php endif;?>
    <?php if ($params->get('navigation')===1) :?>
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
    <?php endif;?>
</div>
<?php
//echo $params->get('autoplay');
$pagination = ($params->get('pagination') === 1) ? 'pagination: {el: ".swiper-pagination_' . $module->id . '",clickable: true,},': 'pagination:false,';
$navigation = ($params->get('navigation') === 1) ? 'navigation: {nextEl: ".swiper-button-next",prevEl: ".swiper-button-prev",},': 'navigation:false,';
$autoplay = ($params->get('autoplay') === 1) ? 'autoplay: {delay: '.$params->get('delay', 1500).',},': 'autoplay: false,';
$wa->addInlineScript('
document.addEventListener("DOMContentLoaded", () => {
    var swiper = new Swiper(".swiper_' . $module->id . '", {
      slidesPerView: ' . $params->get('layout_columns', 3) .','.
	$autoplay.
	$pagination.
	$navigation.
     'spaceBetween: 30,
    });
    });
');?>

