<?php
namespace ImgResize;
//use Joomla\CMS\Log\Log;
//Log::add(print_r('ошибка', true), Log::ERROR, 'my-error');
use Joomla\CMS\Uri\Uri;

class CsResize
{
	private static function resize_image_webp($source_file,$destination_file, $width, $height, $quality=100, $crop=false) {
		list($current_width, $current_height) = getimagesize($source_file);
		$rate = $current_width / $current_height;
		if ($crop) {
			if ($current_width > $current_height) {
				$current_width = ceil($current_width-($current_width*abs($rate-$width/$height)));
			} else {
				$current_height = ceil($current_height-($current_height*abs($rate-$width/$height)));
			}
			$newwidth = $width;
			$newheight = $height;
		} else {
			if ($width/$height > $rate) {
				$newwidth = $height*$rate;
				$newheight = $height;
			} else {
				$newheight = $width/$rate;
				$newwidth = $width;
			}
		}
		$src_file = imagecreatefromwebp($source_file);
		$dst_file = imagecreatetruecolor(round($newwidth), round($newheight));
		imagecopyresampled($dst_file, $src_file, 0, 0, 0, 0, round($newwidth), round($newheight), $current_width, $current_height);

		imagewebp($dst_file, $destination_file, $quality);
	}
	private static function resize_image_jpeg($source_file,$destination_file, $width, $height, $quality=100, $crop=false) {
		list($current_width, $current_height) = getimagesize($source_file);
		$rate = $current_width / $current_height;
		if ($crop) {
			if ($current_width > $current_height) {
				$current_width = ceil($current_width-($current_width*abs($rate-$width/$height)));
			} else {
				$current_height = ceil($current_height-($current_height*abs($rate-$width/$height)));
			}
			$newwidth = $width;
			$newheight = $height;
		} else {
			if ($width/$height > $rate) {
				$newwidth = round($height*$rate);
				$newheight = $height;
			} else {
				$newheight = round($width/$rate);
				$newwidth = $width;
			}
		}
		$src_file = imagecreatefromjpeg($source_file);
		$dst_file = imagecreatetruecolor($newwidth, $newheight);
		imagecopyresampled($dst_file, $src_file, 0, 0, 0, 0, $newwidth, $newheight, $current_width, $current_height);

		imagewebp($dst_file, $destination_file, $quality);
	}
	private static function resize_image_png($source_file,$destination_file, $width, $height, $quality=100, $crop=FALSE) {
		list($current_width, $current_height) = getimagesize($source_file);
		$rate = $current_width / $current_height;
		if ($crop) {
			if ($current_width > $current_height) {
				$current_width = ceil($current_width-($current_width*abs($rate-$width/$height)));
			} else {
				$current_height = ceil($current_height-($current_height*abs($rate-$width/$height)));
			}
			$newwidth = $width;
			$newheight = $height;
		} else {
			if ($width/$height > $rate) {
				$newwidth = round($height*$rate);
				$newheight = $height;
			} else {
				$newheight = round($width/$rate);
				$newwidth = $width;
			}
		}
		$src_file = imagecreatefrompng($source_file);
//		imagepalettetotruecolor($src_file);
//		imagealphablending($src_file, false);
//		imagesavealpha($src_file, true);
		$dst_file = imagecreatetruecolor($newwidth, $newheight);
		$background = imagecolorallocate($dst_file , 255, 255, 255);
		imagecolortransparent($dst_file, $background);
		imagealphablending($dst_file, true);
		imagesavealpha($dst_file, true);
		imagecopyresampled($dst_file, $src_file, 0, 0, 0, 0, $newwidth, $newheight, $current_width, $current_height);

		imagewebp($dst_file, $destination_file, $quality);
	}

	public static function resizeImg($width = 200,$height = 200,$src = ''):array
	{
		$uri = new Uri($src);

		// Удаляем GET-параметры
		$uri->setQuery('');
		$uri->setFragment('');
		// Получаем очищенный URL
		$src = $uri->toString();
		$src = ltrim($src, '/');

		if (!file_exists($src))
		{
			return ['error' => 'Not supported file type'];
		}
		$file_type = strtolower(pathinfo($src, PATHINFO_EXTENSION));

		$file_name = strtolower(pathinfo($src, PATHINFO_FILENAME));
		$file_src  = dirname($src);
		$dir       = $file_src . '/tmb';
		$newSrc    = $dir . '/' . $width . '_' . $height . '_' . $file_name . '.webp';
		if (!is_dir($dir))
		{
			mkdir($dir, 0755);
		}
		switch ($file_type)
		{
			case 'jpeg':
			case 'jpg':
				if (is_file($newSrc))
				{
					return [
						'width'  => $width,
						'height' => $height,
						'src'    => $newSrc,
					];
				}
				else
				{
					self::resize_image_jpeg($src, $newSrc, $width, $height);

					return [
						'width'  => $width,
						'height' => $height,
						'src'    => $newSrc,
					];
				}
			break;
			case 'png':
				if (is_file($newSrc))
				{
					return [
						'width'  => $width,
						'height' => $height,
						'src'    => $newSrc,
					];
				}
				else
				{
					self::resize_image_png($src, $newSrc, $width, $height);

					return [
						'width'  => $width,
						'height' => $height,
						'src'    => $newSrc,
					];
				}
				break;
			case 'webp':
				if (is_file($newSrc))
				{
					return [
						'width'  => $width,
						'height' => $height,
						'src'    => $newSrc,
					];
				}
				else
				{
					self::resize_image_webp($src, $newSrc, $width, $height, 100, false);

					return [
						'width'  => $width,
						'height' => $height,
						'src'    => $newSrc,
					];
				}
				break;
			default:
				return [
					'width'  => null,
					'height' => null,
					'src'    => $src,
				];
		}
	}

}