document.addEventListener('DOMContentLoaded', function () {
    // Создаем кнопку
    const buttonVK = document.createElement('button');
    buttonVK.type = 'button';
    buttonVK.innerHTML = 'Поделиться VK';
    buttonVK.classList.add('btn','btn-primary','btn-postvk');

    // Находим контейнер кнопок и добавляем нашу кнопку
    const toolbarContent = document.querySelector('#general .form-vertical');
    if (toolbarContent) {
        toolbarContent.prepend(buttonVK);
    }

   const token = Joomla.getOptions('csrf.token'); // Получаем CSRF-токен

    buttonVK.addEventListener('click', function () {
       Joomla.request({
           url: 'index.php?option=com_ajax&plugin=postvk&group=content&format=raw',
           method: 'POST',
           headers: {
               'Cache-Control' : 'no-cache',
               'Content-Type': 'application/json',
               'charset':'utf-8'
           },
           data: JSON.stringify({
               'id':phpData.id,
               'catid':phpData.catid,
               'title':phpData.title,
               'introtext':phpData.introtext,
               'alias':phpData.alias,
               'metakey':phpData.metakey,
               'images':phpData.images,
               [token]: 1
           }),
           onBefore: function (xhr){
               Joomla.renderMessages({'warning': [`<div className="spinner-border text-primary" role="status"><span className="visually-hidden">Немного подождите, идёт публикация...</span></div>`]});
           },
           onSuccess: function (response, xhr){
               if (response !== ''){
                   let data = JSON.parse(response);
                   if (data.success){
                       Joomla.renderMessages({'success': [data.success]});
                   }
                   if (data.error){
                       Joomla.renderMessages({'error': [data.error]});
                   }
                   console.log(data);
               }
           },
           onError: function(xhr){
               console.error(xhr.status + ' - ' + xhr.statusText);
               },
           onComplete: function (xhr){
           }
       });
   })
})