<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_rmshippinglist
 *
 * @copyright   
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalMart\Site\Helper\RouteHelper;

?>
<div class="row row-cols-2 row-cols-sm-<?php echo $params['column']; ?>">
    <?php foreach ($list as $item) : ?>
        <div class="col-auto position-relative mb-4">
            <?php
            //Формируем ссылку на товара
            $slug = $item['id'] . ':' . $item['alias'];
            $link = Route::link('site', RouteHelper::getProductRoute($slug, $item['category'], '*'));?>
            <?php
            if ($params['image']){
                //путь к изображению товара
                $media = json_decode($item['media']);
                //dd($media);
                $layoutAttr = [
                    'src' => $media->image,
                    'alt' => 'Изображение '. $item['title'],
                    'class' => 'h-auto',
                    'loading' => 'lazy'
                ];
                ?>
                <div class="ratio ratio-1x1 mb-4 overflow-hidden ">
                    <?php echo LayoutHelper::render('joomla.html.image', $layoutAttr); ?>
                </div>
            <?php } ?>
            <div class="rm-product-info">
                <a href="<?php echo $link; ?>" class="stretched-link"></a>
                <?php if ($params['categoryname']) : ?>
                    <p class="rm-product-category small"><?php echo $item['category_title']; ?></p>
                <?php endif; ?>
                <p class="mb-2 fw-300"><?php echo $item['title']; ?></p>
                <p class="fw-300"><?php echo $item['ordering_price']; ?></p>
            </div>

        </div>
    <?php endforeach; ?>
</div>
