<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_empty
 *
 * @copyright   (C) 2025 www.codersite.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Module\Empty\Site\Helper;

use Joomla\CMS\Application\SiteApplication;
use Joomla\Database\DatabaseAwareInterface;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Registry\Registry;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Helper for mod_empty
 *
 * @since  1.5
 */
class EmptyHelper implements DatabaseAwareInterface
{
    use DatabaseAwareTrait;

    /**
     * Returns a list from an array
     *
     * @param   Registry         $moduleParams  The module parameters.
     * @param   SiteApplication  $app           The current application.
     *
     * @return  string
     *
     * @since   4.4.0
     */
    public function getModuleData(Registry $moduleParams, SiteApplication $app): string
    {
	    $list = $moduleParams->get('text');
		if (empty($list)) {
			return '';
		}
        return json_encode($list);
    }

}
