if (typeof Vue === 'undefined') {
    console.error('Vue.js is not loaded!');
}
const { ref, onMounted } = Vue;

const App = {
    setup() {
        const data = ref('');
        const loading = ref(true);
        const loadContent = async (id, image = null, ordering = 'a.publish_up', direction = 'DESC', count = '1') => {
            loading.value = true;
            const formData = new FormData();
            formData.append('option', 'com_ajax');
            formData.append('format', 'raw');
            formData.append('plugin', 'getArticles');
            formData.append('catid', id);
            formData.append('image', image);
            formData.append('ordering', ordering);
            formData.append('direction', direction);
            formData.append('count', count);

            try {
                const response = await fetch('/index.php', {
                    method: 'POST',
                    body: formData
                });

                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }

                const jsonData = await response.json(); // Предполагаем, что плагин возвращает JSON

                // Проверяем, есть ли ошибка в ответе
                if(jsonData.error) {
                    console.error('Ошибка от плагина:', jsonData.error);
                    data.value = []; // Очищаем массив данных
                    return;
                }

                data.value = jsonData;
                return jsonData;
            } catch (error) {
                console.error('Ошибка загрузки:', error);
            } finally {
                loading.value = false;
            }
        };

        onMounted(() => {
            const initialCatId = window.MOD_VUEARTICLE_CATID;
            const initialImgType = window.MOD_VUEARTICLE_IMGTYPE;
            const initialOrdering = window.MOD_VUEARTICLE_ORDERING;
            const initialDirection = window.MOD_VUEARTICLE_DIRECTION;
            const initialCount = window.MOD_VUEARTICLE_COUNT;
            loadContent(initialCatId,initialImgType,initialOrdering,initialDirection,initialCount);
        });
        return { loadContent, data, loading };
    }
};

document.addEventListener('DOMContentLoaded', function() {
    const appElement = document.querySelector('.list-articles-vue');
    if (appElement) {
        const app = Vue.createApp(App);
        app.mount('.list-articles-vue');
    } else {
        console.warn('Элемент с id="app" не найден в DOM при попытке монтирования Vue.');
    }
});