<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_vuearticle
 *
 * @copyright   (C) 2025 www.codersite.ru
 * @license     GNU General Public License version 2 or later;
 *
 * @var $moduleUri string Путь до папки модуля
 */
use Joomla\CMS\Factory;
defined('_JEXEC') or die;
$params = json_decode($module->params, true);
//dd($params);
$catId = (int)$params['category'];
$isImage = (string)$params['image'];
$imageType = null;
if ($isImage == '1') {
    $imageType = (string)$params['image_type'];
}
$ordering = (string)$params['ordering'];
$direction = (string)$params['direction'];
$countArticles = (int)$params['count'];

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->registerAndUseScript('vuejs', $moduleUri.'vue/vue.global.js', [], [], ['core']);
$wa->registerAndUseScript('vuesalon', $moduleUri.'vue/get-articles.js', [], [], ['vuejs']);
$doc = Factory::getApplication()->getDocument();
// Используем метод addScriptDeclaration у документа
$doc->addScriptDeclaration('
    window.MOD_VUEARTICLE_CATID = ' . $catId . ';
    window.MOD_VUEARTICLE_IMGTYPE = "' . $imageType . '";
    window.MOD_VUEARTICLE_ORDERING = "' . $ordering . '";
    window.MOD_VUEARTICLE_DIRECTION = "' . $direction . '";
    window.MOD_VUEARTICLE_COUNT = "' . $countArticles . '";
');
?>
<div class="list-articles-vue">
    <div v-if="loading">Загрузка...</div>
        <div v-else v-for="article in data" :key="article.id" class="article-item">
            <h3>
                <a :href="article.url">
                    <template v-if="article.title">
                        {{ article.title }}
                    </template>
                </a>
            </h3>
            <div v-html="article.introtext" class="article-item-content"></div>
            <div v-if="article.image" class="article-item-image">
                <img :src="article.image.url" :alt="article.title" :width="article.image.attributes?.width" :height="article.image.attributes?.height" loading="lazy" />
            </div>
        </div>
</div>
