<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  content.cs_tmb_fancybox
 *
 * @copyright   (C) 2025 www.codersite.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace CS\Plugin\Content\CsTmbFancybox\Extension;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Router\SiteRouterAwareTrait;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\CMS\Uri\Uri;


\defined('_JEXEC') or die;


final class CsTmbFancybox extends CMSPlugin implements SubscriberInterface
{
	use SiteRouterAwareTrait;
	use DatabaseAwareTrait;
	use UserFactoryAwareTrait;

    //protected static array $types;
    protected static string $types,$class;

	public function __construct(&$subject, $config = [])
	{
        parent::__construct($subject, $config);
        self::$types = $this->params->get('types', '');
        self::$class = $this->params->get('class', '');
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'onContentPrepare' => 'onContentPrepare'
		];
	}

    public function onContentPrepare(Event $event): void
    {
        if (!$this->getApplication()->isClient('site')) {
            return;
        }
        $context = $event->getArgument('context');

        if ($context !== 'com_content.article') return;

        $item = $event->getArgument('item');

        $text = $item->text;
        // Регулярное выражение для поиска изображений
        $pattern = '/<img\s+[^>]*src=["\']([^"\']+)["\'][^>]*>/i';


        $text = preg_replace_callback($pattern, function($matches) {
            $imgTag = $matches[0];
            $imgSrc = $matches[1];

            // Проверяем, не обернуто ли изображение уже в ссылку
            if (str_contains(rtrim($imgTag, '>'), '<a ') || str_contains(rtrim($imgTag, '>'), '<a>')) {
                return $imgTag;
            }
            // Если выбрана обработка изображений когда задана ширина и она меньше реального размера изображения
            if(self::$types == 'is_width') {
                // Извлекаем параметр width
                if (preg_match('/width=["\'](\d+)["\']/i', $imgTag, $widthMatches)) {
                    $width = (int)$widthMatches[1];
                    // Получаем реальный размер изображения
                    $uri = Uri::getInstance();
                    $base = $uri->toString(['scheme', 'host', 'port']);
                    $fullPath = JPATH_ROOT . str_replace($base, '', '/'.$imgSrc);

                    if (file_exists($fullPath)) {
                        $imageInfo = getimagesize($imgSrc);
                        if ($imageInfo !== false) {
                            $realWidth = $imageInfo[0];

                            if ($width < $realWidth) {
                                return $this->returnImgTag($imgTag, $imgSrc);
                            } else {
                                return $imgTag;
                            }
                        }
                    }
                }
            }
            // Если выбрана обработка изображений по классу
            if(self::$types == 'is_class' && !empty(self::$class)) {
                $arrayClasses = array_map('trim', explode(',', self::$class));
                $hasAllowedClass = false;
                if (preg_match('/class=["\']([^"\']+)["\']/i', $imgTag, $classMatches)) {
                    $classArray = explode(' ', $classMatches[1]);
                    $hasAllowedClass = !empty(array_intersect($arrayClasses, $classArray));
                }
                if ($hasAllowedClass) {
                    return $this->returnImgTag($imgTag, $imgSrc);
                } else {
                    return $imgTag;
                }
            }
            return $imgTag;
        }, $text);
        $item->text = $text;
    }
    private function returnImgTag($imgTag, $imgSrc) {
        return '<a href="' . htmlspecialchars($imgSrc) . '" data-fancybox="gallery" data-caption="">' . $imgTag . '</a>';
    }

}
