<?php
namespace ImgResize;
use Joomla\CMS\Log\Log;
//Log::add(print_r('ошибка', true), Log::ERROR, 'my-error');
use Joomla\CMS\Uri\Uri;
class CsResize
{
	private static function newSize($crop, $current_width, $current_height, $width, $height):array
	{
		$rate = $current_width / $current_height;
		if ($crop) {
			if ($current_width > $current_height) {
				$width = ceil($current_width-($current_width*abs($rate-$width/$height)));
			} else {
				$height = ceil($current_height-($current_height*abs($rate-$width/$height)));
			}
			$newwidth = $width;
			$newheight = $height;
		} else {
			if ($width/$height > $rate) {
				$newwidth = round($height*$rate);
				$newheight = $height;
			} else {
				$newheight = round($width/$rate);
				$newwidth = $width;
			}
		}
		return [
			'width' => round($newwidth),
			'height' => round($newheight)
		];
	}
	private static function resize_image_webp($source_file,$destination_file, $width, $height, $quality=100, $crop=false) :array
	{
		list($current_width, $current_height) = getimagesize($source_file);

		$newSize = self::newSize($crop, $current_width, $current_height, $width, $height);

		$src_file = imagecreatefromwebp($source_file);
		$dst_file = imagecreatetruecolor($newSize['width'], $newSize['height']);
		imagecopyresampled($dst_file, $src_file, 0, 0, 0, 0,$newSize['width'], $newSize['height'], $current_width, $current_height);

		$result['success'] = imagewebp($dst_file, $destination_file, $quality);
		$result['width'] = $newSize['width'];
		$result['height'] = $newSize['height'];

		return $result;
	}
	private static function resize_image_jpeg($source_file,$destination_file, $width, $height, $quality=100, $crop=false) :array
	{
		list($current_width, $current_height) = getimagesize($source_file);

		$newSize = self::newSize($crop, $current_width, $current_height, $width, $height);

		$src_file = imagecreatefromjpeg($source_file);
		$dst_file = imagecreatetruecolor($newSize['width'], $newSize['height']);
		imagecopyresampled($dst_file, $src_file, 0, 0, 0, 0, $newSize['width'], $newSize['height'], $current_width, $current_height);

		$result['success'] = imagewebp($dst_file, $destination_file, $quality);
		$result['width'] = $newSize['width'];
		$result['height'] = $newSize['height'];

		return $result;
	}
    private static function resize_image_png($source_file, $destination_file, $width, $height, $quality = 100, $crop = FALSE): array
    {
        // Получаем размеры исходного изображения
        list($current_width, $current_height) = getimagesize($source_file);

        // Вычисляем новые размеры
        $newSize = self::newSize($crop, $current_width, $current_height, $width, $height);

        // Создаем исходное изображение из PNG
        $src_file = imagecreatefrompng($source_file);

        // Создаем целевое изображение с поддержкой прозрачности
        $dst_file = imagecreatetruecolor($newSize['width'], $newSize['height']);

        // Настройка прозрачности
        imagealphablending($dst_file, false); // Отключаем смешивание цветов
        imagesavealpha($dst_file, true);      // Включаем сохранение альфа-канала

        // Копируем и изменяем размер изображения
        imagecopyresampled(
            $dst_file,
            $src_file,
            0, 0, 0, 0,
            $newSize['width'],
            $newSize['height'],
            $current_width,
            $current_height
        );

        // Сохраняем результат в формате WebP
        $result['success'] = imagewebp($dst_file, $destination_file, $quality);
        $result['width'] = $newSize['width'];
        $result['height'] = $newSize['height'];

        // Освобождаем память
        imagedestroy($src_file);
        imagedestroy($dst_file);

        return $result;
    }
    private static function get_imageSize($srcImg): array
    {
        $width = '';
        $height = '';
        $size = getimagesize($srcImg);
        if (is_array($size)) {
            $width = $size[0];
            $height = $size[1];
        }
        return [
            'src'=> $srcImg,
            'width' => $width,
            'height' => $height
        ];
    }

	public static function resizeImg($width = 200,$height = 200,$src = '')
	{
		$uri = new Uri($src);
		// Удаляем GET-параметры
		$uri->setQuery('');
		$uri->setFragment('');
		// Получаем очищенный URL
		$src = $uri->toString();
		$src = ltrim($src, '/');

		if (!file_exists($src))
		{
			return [
                'error' => 'Not supported file type',
                'src'    => $src,
            ];
		}
		$file_type = strtolower(pathinfo($src, PATHINFO_EXTENSION));

		$file_name = strtolower(pathinfo($src, PATHINFO_FILENAME));
		$file_src  = dirname($src);
		$dir       = $file_src . '/tmb';
		$newSrc    = $dir . '/' . $width . '_' . $height . '_' . $file_name . '.webp';
		if (!is_dir($dir))
		{
			mkdir($dir, 0755);
		}
		switch ($file_type)
		{
			case 'jpeg':
			case 'jpg':
				if (is_file($newSrc))
				{
                    return self::get_imageSize($newSrc);
				}
				else
				{
					$jpg = self::resize_image_jpeg($src, $newSrc, $width, $height);
					if ($jpg['success']) {
						return [
							'width'  => $jpg['width'],
							'height' => $jpg['height'],
							'src'    => $newSrc,
						];
					}
				}
			break;
			case 'png':
				if (is_file($newSrc))
				{
                    return self::get_imageSize($newSrc);
				}
				else
				{
					$png = self::resize_image_png($src, $newSrc, $width, $height);
					if ($png['success']) {
						return [
							'width'  => $png['width'],
							'height' => $png['height'],
							'src'    => $newSrc,
						];
					}
				}
				break;
			case 'webp':
				if (is_file($newSrc))
				{
                    return self::get_imageSize($newSrc);
				}
				else
				{
					$webp = self::resize_image_webp($src, $newSrc, $width, $height, 100, false);
					if ($webp['success']) {
						return [
							'width'  => $webp['width'],
							'height' => $webp['height'],
							'src'    => $newSrc,
						];
					}
				}
				break;
			default:
				return [
					'width'  => null,
					'height' => null,
					'src'    => $src,
				];
		}
	}
}
