<?php
namespace Declension;
/**
 * @package     Joomla.Plugin
 * @subpackage  libraries
 *
 * * Склонение существительных после числительных
 * @param int $number Число
 * @param array $forms Массив форм: [станок, станка, станков]
 * @return string
 *
 * @copyright   (C) 2025 www.codersite.ru
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Mitriy_Bug
 * @version     1.0
 * @since       1.0
 */
class Declension
{
	public static function makeDeclensionNumber (int $number, array $forms) : string
    {
        $number = abs($number) % 100;
        $n1 = $number % 10;

        if ($number > 10 && $number < 20) {
            return $forms[2];
        }

        if ($n1 > 1 && $n1 < 5) {
            return $forms[1];
        }

        if ($n1 == 1) {
            return $forms[0];
        }

        return $forms[2];
    }
}
