<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_csswiper
 *
 * @copyright   (C) 2025 www.codersite.ru
 * @license     GNU General Public License version 2 or later;
 *              $sliders - array of sliders
 */

defined('_JEXEC') or die;
use Joomla\CMS\HTML\HTMLHelper;

$wa = $app->getDocument()->getWebAssetManager();
$wa->registerAndUseStyle('mod_csswiper', 'media/mod_csswiper/css/swiper-bundle.min.css');
$wa->registerAndUseScript('mod_csswiper', 'media/mod_csswiper/js/swiper-bundle.min.js');

$data = json_decode($sliders, true);
$ratio = $params->get('ratio', '4x3');
?>
<?php
if (!empty($data)) :?>
	<!-- Slider main container -->
	<div class="swiper swiper_<?php echo $module->id; ?> pb-4">
	<!-- Additional required wrapper -->
	<div class="swiper-wrapper mb-3">
	<?php foreach ($data as $slide) { ?>
            <?php if ($slide['img_slider'] == '') continue; ?>
		<div class="swiper-slide overflow-hidden ratio ratio-<?=$ratio?>">
            <div>
                <?
                $img = HTMLHelper::_('cleanImageURL', $slide['img_slider']);
                ?>
                <img
                        class="img-fluid object-fit-cover position-absolute top-50 start-50 translate-middle"
                        src="<?php echo $img->url; ?>"
                        alt="<?php echo $slide['title_slider'] ?? ''; ?>"
                        width="<?php echo $img->attributes['width'] ?? ''; ?>"
                        height="<?php echo $img->attributes['height'] ?? ''; ?>"
                        loading="lazy"
                >
            </div>

		</div>
	<?php }	?>
	</div>
		<!-- If we need pagination -->
		<div class="swiper-pagination_<?=$module->id?> d-flex justify-content-center"></div>

		<!-- If we need navigation buttons -->
		<div class="swiper-button-prev"></div>
		<div class="swiper-button-next"></div>
	</div>
	<?php
	$pagination = ($params->get('pagination') === 1) ? 'pagination: {el: ".swiper-pagination_' . $module->id . '",clickable: true,},': 'pagination:false,';
	$navigation = ($params->get('navigation') === 1) ? 'navigation: {nextEl: ".swiper-button-next",prevEl: ".swiper-button-prev",},': 'navigation:false,';
	$autoplay = ($params->get('autoplay') === 1) ? 'autoplay: {delay: '.$params->get('delay', 1500).',},': 'autoplay: false,';
	$wa->addInlineScript('
document.addEventListener("DOMContentLoaded", () => {
    var swiper = new Swiper(".swiper_' . $module->id . '", {
      slidesPerView: 1,'.
		$autoplay.
		$pagination.
		$navigation.
		'spaceBetween: 30,
        breakpoints: {
            768: {
              slidesPerView: ' . $params->get('layout_columns', 3) .',
              spaceBetween: 20,
            },
          },
        });
    });
');?>

<?php
endif;
