<?php
namespace Joomla\Plugin\Content\Postvk\Extension;

// no direct access
defined('_JEXEC') or die;

use CURLFile;
use JHtml;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

class Postvk extends CMSPlugin implements SubscriberInterface
{
	// Настройки
	protected static string $userToken, $groupId, $apiVersion, $idAlbum, $textTruncate;
	public function __construct(&$subject, $config = [])
	{
		// Вызываем родительский конструктор
		parent::__construct($subject, $config);
		// Получаем значение параметров
		self::$userToken = $this->params->get('tokenUser', '');
		self::$groupId = $this->params->get('groupVkId', '');
		self::$idAlbum = $this->params->get('idAlbum', '');
		self::$apiVersion = $this->params->get('apiVersion', '5.131');
		self::$textTruncate = $this->params->get('textTruncate', '200');
	}

    public static function getSubscribedEvents(): array
    {
        return [
            'onAjaxPostvk' => 'onAjaxPostvk',
            'onContentPrepareForm' => 'onContentPrepareForm',
            ];
    }
	private function sendVk($data) : array
	{
		$uri = Uri::getInstance();
		$protocol = $uri->getScheme(); // 'http' или 'https'
		$host = $uri->getHost();
		$domain = $protocol . '://' . $host;
		// Текст поста
		$link = Route::link('site','index.php?option=com_content&view=article&id='.$data['id'].'&catid='.$data['catid']);

		$message     = $data['title'] . "\n\n". $data['introtext'];

		if($this->params->get('isKey', ''))
		{
			$metakey = $data['metakey'];
			if ($metakey)
			{
				$words         = explode(' ', $metakey);
				$modifiedWords = array_map(function ($word) {
					return '#' . $word;
				}, $words);
				$result        = implode(' ', $modifiedWords);
				$message       .= "\n\n" . $result . "\n\n";
			}
		}

		if($this->params->get('isLink', '')){
			$message    .= "\n\n". $this->params->get('textBeforeLink', '') . $domain . $link;
		}

		$attachments = 'photo-'.self::$groupId.'_'.$this->saveWallPhoto($domain.'/'.$data['images'],$message); // Прикрепленные материалы (например, фото)

		// URL для запроса
		$url = "https://api.vk.com/method/wall.post";

		// Параметры запроса
		$params = [
			'owner_id'     => '-'.self::$groupId,
			'message'      => $message,
			'attachments'  => $attachments,
			'from_group'   => 1, // Публикация от имени группы
			'access_token' => self::$userToken,
			'v'            => self::$apiVersion,
		];

		// Отправка POST-запроса
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($ch);
		curl_close($ch);

		// Обработка ответа
		$result = json_decode($response, true);

		if (isset($result['error']))
		{
			return ['error' => "Ошибка: " . $result['error']['error_msg']];
		}
		else
		{
			return ['success' => "Пост успешно опубликован!"];
		}
	}
	private function getWallUploadServer() : array
	{
		// Формируем URL для запроса
		$url = "https://api.vk.com/method/photos.getUploadServer";

		// Параметры запроса
		$params = [
			'group_id' => self::$groupId, // ID группы без минуса
			'album_id' => self::$idAlbum,
			'access_token' => self::$userToken,
			'v' => self::$apiVersion,
		];
		// Отправляем GET-запрос
		$response = file_get_contents($url . '?' . http_build_query($params));
		$data = json_decode($response, true);
		if (isset($data['error'])) {
			return ['error' =>"Ошибка: " . $data['error']['error_msg']];
		} else {
			return $data['response'];
		}
	}
	private function saveWallPhoto($urlFile,$message) : string
	{
		// Формируем URL для запроса
		$url = "https://api.vk.com/method/photos.save";
		$sendPhotoInVk = $this->sendPhotoInVk($urlFile);
		// Параметры запроса
		$params = [
			'album_id' => self::$idAlbum,
			'group_id' => self::$groupId, // ID группы без минуса
			'photos_list' => $sendPhotoInVk['photos_list'],
			'caption'   => $message,
			'server' => $sendPhotoInVk['server'],
			'hash' => $sendPhotoInVk['hash'],
			'access_token' => self::$userToken,
			'v' => self::$apiVersion,
		];
		// Отправляем POST-запрос
		$response = file_get_contents($url . '?' . http_build_query($params));
		$data = json_decode($response, true);

		if (isset($data['error'])) {
			return "Ошибка: " . $data['error']['error_msg'];
		} else {
			return $data['response'][0]['id'];
		}
	}
	private function sendPhotoInVk($urlFile) : array
	{
		// Подготовка Url для загрузки фото
		$uploadUrl = $this->getWallUploadServer();

		// Подготовка POST-запроса
		$postData = [
			'file' => new CURLFile($urlFile),
		];

		// Инициализация cURL
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $uploadUrl['upload_url']);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Отправка запроса
		$response = curl_exec($ch);
		curl_close($ch);

		// Обработка ответа
		$uploadResult = json_decode($response, true);

		if (isset($uploadResult['error'])) {
			return ['error' => "Ошибка при загрузке: " . $uploadResult['error']['error_msg']];
		} else {
			return $uploadResult;
		}
	}
	/**
	 * Добавляем кнопку на страницу редактирования материала.
	 */
	public function onContentPrepareForm(Event $event): void
	{
		// Получаем форму и данные контекста
		$form = $event->getArgument('form');
		$data = $event->getArgument('data');

		if(empty($data)){
			return;
		}
		// Проверяем, что мы находимся на странице редактирования статьи
		if ($form->getName() !== 'com_content.article') {
			return;
		}
		// Получаем приложение Joomla
		$app = Factory::getApplication();
		// Проверяем, что мы в админке
		if (!$app->isClient('administrator')) {
			return;
		}

		// Подключаем JavaScript для кнопки
		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

		// Данные, которые нужно передать в JavaScript
		function cleanImagePath($path): string
	{
		// Убираем часть после символа #
		$path = strtok($path, '#');
		// Убираем GET-параметры (часть после ?)
		$path = strtok($path, '?');
		return $path;
	}
		$dataArr = [
			'id'        =>  $data->id,
            'catid'     =>  $data->catid,
            'title'     =>  $data->title,
			'metakey'   =>  $data->metakey,
            'introtext' =>  JHtml::_('string.truncate', strip_tags($data->introtext), self::$textTruncate),
            'alias'     =>  $data->alias,
            'images'    =>  cleanImagePath($data->images['image_intro']),
		];
		// Преобразуем данные в JSON
		$jsonData = json_encode($dataArr);
		// Добавляем встроенный JavaScript с данными
		$wa->addInlineScript("
                const phpData = " . $jsonData . ";
        ", ['position' => 'before'], [], ['postvk']);

		$wa->registerAndUseScript('postvk','plugins/content/postvk/js/postvk.js', [], ['defer' => false], ['core']);
	}
	public function onAjaxPostvk(Event $event)
	{
		$app = Factory::getApplication();
		// Проверка CSRF-токена в POST-запросе
		if (!Session::checkToken('post')) {
			echo json_encode(['status' => 'error', 'message' => 'Неверный токен']);
			$app->close();
		}
		$postData = $app->input->json->getArray();
		$arr = $this->sendVk($postData);
		$event->setArgument('result', json_encode($arr));
	}
}